extends CanvasLayer
class_name Skins
# This class is responsible for managing games skins 



var _selected_skin : SkinHolder
var _skin_holders : Array
var _reward_value := 52
var _skin_price := 150

onready var _skins_col_1 : Control = get_node("bg/main/list/bg/line/col_1")
onready var _skins_col_2 : Control = get_node("bg/main/list/bg/line/col_2")
onready var _coins : Coins = get_node("bg/main/quit_coins/coins")
onready var _btns_container : HBoxContainer = get_node("bg/main/reward/HBoxContainer")
onready var _rewarded_coins_cnt : Label = get_node(
	"bg/main/reward/HBoxContainer/rewarded_coins/btn_reward/hbox/text/collectable_reward")
onready var _price_coins_cnt : Label = get_node(
	"bg/main/reward/HBoxContainer/purchase/btn_purchase/hbox/text/collectable_reward")
onready var _reward_coins_icon : TextureRect = get_node(
	"bg/main/reward/HBoxContainer/rewarded_coins/btn_reward/hbox/icon/collectable_icon")
onready var _buy_coins_icon : TextureRect = get_node(
	"bg/main/reward/HBoxContainer/purchase/btn_purchase/hbox/icon/collectable_icon")
onready var _current_skin_texture : TextureRect = get_node(
	"bg/main/current/center/icon_current_item")
onready var _animation : AnimationPlayer = get_node("AnimationPlayer")


func _ready() -> void:
	init(B4DFramework.get_coins_count() , B4DFramework.get_coin_texture())
	_set_skins()
	B4DFramework.b4d_ads.connect("rewarded",self,"_reward")
	B4DFramework.b4d_ads.connect("interstitial_closed",self,"_interstitial_closed")


func init(coins_cnt : int , coins_text : Texture ) -> void:
	_coins.init(coins_cnt,coins_text)
	_reward_coins_icon.texture = coins_text
	_buy_coins_icon.texture = coins_text
	_current_skin_texture.texture = B4DFramework.get_skins_textures()[B4DFramework.get_skin() - 1]
	_check_unlocked()
	_set_reward_value()
	_set_skin_price()
#	_set_ads_depend_ui()

func _set_skins():
	var skin_holders_parents := []
	
	skin_holders_parents.append(_skins_col_1.get_children())
	skin_holders_parents.append(_skins_col_2.get_children())
	
	var index := 0 
	for parent in skin_holders_parents: # Col1 
		for skin_holder in parent:
			_skin_holders.append(skin_holder) # Add skin holder to the array 
			
			var skin_id := index + 1
			var purchased : Array = B4DFramework.get_skins_purchased()
			
			skin_holder.init(skin_id,B4DFramework.get_skins_textures()[index])
			skin_holder.connect("pressed",self,"_on_skin_selected",[skin_holder])
			
			if  skin_id in purchased: #  purchased
				skin_holder.unlock()
			else: # Not Purchased
				skin_holder.lock()
			
			if skin_id == B4DFramework.get_skin():
				skin_holder.select()
				_selected_skin = skin_holder
			else:
				skin_holder.unselect()

			index += 1


func _on_skin_selected(skin : SkinHolder):
	var purchased_skins : Array = B4DFramework.get_skins_purchased()
	if not skin.get_id() in purchased_skins:
		return
	_selected_skin.unselect()
	skin.select()
	
	_selected_skin = skin
	_current_skin_texture.texture = skin.get_texture()
	UserData.update_skins(skin.get_id(),purchased_skins)


# Unlock a random new skin 
func _unlock_random_skin() -> void:
	var random_skin = B4DFramework.get_rand_locked_skin()
	_skin_holders[random_skin - 1].purchase()
	

	UserData.update_skins(B4DFramework.get_skin(),
		B4DFramework.get_skins_purchased() + [random_skin])
	UserData.update_score(B4DFramework.get_coins_count() - _skin_price,
		B4DFramework.get_level())


func _check_unlocked() -> void:
	if B4DFramework.get_skins_purchased().size() == 6:
		_btns_container.visible = false


func _on_purchase_pressed() -> void:
	if B4DFramework.b4d_ads.get_is_interstitial_loaded():
		B4DFramework.b4d_ads.show_interstitial()
	else:
		_interstitial_closed()


func _on_reward_pressed() -> void:
	Sounds.play_tap_sound()
	if B4DFramework.b4d_ads.is_rewarded_video_loaded():
		B4DFramework.b4d_ads.show_rewarded_video()
	else:
		B4DFramework.pop_notif.show()
		B4DFramework.b4d_ads.load_rewarded_video()


func _interstitial_closed() -> void:
	if _animation.is_playing() :
		return
	Sounds.play_tap_sound()
	if _skin_price > B4DFramework.get_coins_count():
		_animation.play("skins_purchase_no_coins")
		return
	UiAnimations.btn_press(get_node("bg/main/reward/HBoxContainer/purchase/btn_purchase"))
	_animation.play("skins_random")
	yield(_animation,"animation_finished")
	_unlock_random_skin()
	_check_unlocked()


func _reward(currency , amount) -> void:
	UiAnimations.btn_press(get_node("bg/main/reward/HBoxContainer/rewarded_coins/btn_reward"))
	UserData.update_score(B4DFramework.get_coins_count() + _reward_value , B4DFramework.get_level())
	_set_reward_value()


func _on_quit_pressed():
	Sounds.play_tap_sound()
	get_tree().change_scene_to(B4DFramework.game_scn)


func _set_reward_value() -> void:
	var random_reward := ceil(rand_range(30,70))
	_reward_value = random_reward
	_rewarded_coins_cnt.text = "+ " + str(_reward_value)


func _set_skin_price() -> void:
	_skin_price = B4DFramework.get_skins_purchased().size() *  21 + 125
	_price_coins_cnt.text = str(_skin_price)


func _set_ads_depend_ui():
	if not B4DFramework.is_ads_active:
		var reward_btn : Control = get_node(
			"bg/main/reward/HBoxContainer/rewarded_coins")
		reward_btn.visible = false
	
